% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuppressDec.R
\name{SuppressDec}
\alias{SuppressDec}
\title{Suppressed tabular data: Inner cell frequencies as decimal numbers}
\usage{
SuppressDec(
  x,
  z = NULL,
  y = NULL,
  suppressed = NULL,
  digits = 9,
  nRep = 1,
  yDeduct = NULL,
  resScale = NULL,
  rmse = NULL,
  sparseLimit = 500
)
}
\arguments{
\item{x}{Dummy matrix where the dimensions matches z and/or y input. Sparse matrix (Matrix package) is possible.}

\item{z}{Frequencies to be published. All, only the safe ones or with suppressed as NA.}

\item{y}{Inner cell frequencies (see details).}

\item{suppressed}{Logical vector defining the suppressed elements of z.}

\item{digits}{Output close to whole numbers will be rounded using \code{digits} as input to \code{\link[SSBtools]{RoundWhole}}.}

\item{nRep}{Integer, when >1, several y's will be generated. Extra columns in output.}

\item{yDeduct}{Values to be subtracted from y and added back after the calculations. 
Can be used to perform the modulo method described in the paper (see examples).}

\item{resScale}{Residuals will be scaled by resScale}

\item{rmse}{Desired root mean square error (residual standard error). Will be used when resScale is NULL or cannot be used.}

\item{sparseLimit}{Limit for the number of rows of a reduced x-matrix within the algorithm. When exceeded, a sparse algorithm is used 
(see \code{\link{IpsoExtra}}).}
}
\value{
The inner cell frequencies as decimal numbers
}
\description{
Assume that frequencies to be published, \code{z}, can be computed from inner 
frequencies, \code{y}, via \code{ z = t(x) \%*\% y}, 
where \code{x} is a dummy matrix. 
Assuming correct suppression, this function will generate safe inner cell frequencies as decimal numbers.
}
\details{
This function makes use of \code{\link{ReduceX}} and \code{\link{RegSDCipso}}.
It is not required that \code{y} consists of cell frequencies. A multivariate \code{y} or \code{z} is also possible. 
Then several values are possible as \code{digits}, \code{resScale} and \code{rmse} input.
}
\note{
Capital letters, X, Y and Z, are used in the paper.
}
\examples{
# Same data as in the paper
z <- RegSDCdata("sec7z")
x <- RegSDCdata("sec7x")
y <- RegSDCdata("sec7y")  # Now z is t(x) \%*\% y 
zAll <- RegSDCdata("sec7zAll")
zAllSupp <- RegSDCdata("sec7zAllSupp")
xAll <- RegSDCdata("sec7xAll")

# When no suppression, output is identical to y
SuppressDec(xAll, zAll, y)
SuppressDec(xAll, zAll)  # y can be seen in z

# Similar to Y* in paper (but other random values)
SuppressDec(x, z, y)

# Residual standard error forced to be 1
SuppressDec(x, z, y, rmse = 1)

# Seven ways of obtaining the same output
SuppressDec(x, z, rmse = 1)  # slower, y must be estimated
SuppressDec(x, y = y, rmse = 1)
SuppressDec(xAll, zAllSupp, y, rmse = 1)
SuppressDec(xAll, zAllSupp, rmse = 1)  # slower, y must be estimated
SuppressDec(xAll, zAll, y, is.na(zAllSupp), rmse = 1)
SuppressDec(xAll, zAll, suppressed = is.na(zAllSupp), rmse = 1)  # y seen in z
SuppressDec(xAll, y = y, suppressed = is.na(zAllSupp), rmse = 1)

# YhatMod4 and YhatMod10 in Table 2 in paper
SuppressDec(xAll, zAllSupp, y, yDeduct = 4 * (y\%/\%4), resScale = 0)
SuppressDec(xAll, zAllSupp, y, yDeduct = 10 * (y\%/\%10), rmse = 0)

# As data in Table 3 in paper (but other random values)
SuppressDec(xAll, zAllSupp, y, yDeduct = 10 * (y\%/\%10), resScale = 0.1)

# rmse instead of resScale and 5 draws
SuppressDec(xAll, zAllSupp, y, yDeduct = 10 * (y\%/\%10), rmse = 1, nRep = 5)
}
\author{
Øyvind Langsrud
}
