% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Number_of_failes.R
\name{Number_of_failes}
\alias{Number_of_failes}
\title{Comparison of groupings}
\usage{
Number_of_failes(grouping_exact, grouping_obtained)
}
\arguments{
\item{grouping_exact}{List. Each component of the list contains a vector with the components of one group. This list represents the actual grouping of the data.}

\item{grouping_obtained}{List. Each component of the list contains a vector with the components of one group. This list represents the grouping obtained by some mathematical method.}
}
\value{
Returns a number with the quantity of points that are misclassified in the \code{grouping_obtained}.
}
\description{
This function compares the real clustering with a clustering obtained with some mathematical method. For each group, this function calculates the number of components that are in the expected grouping that are not in the real grouping. This function adds this value for all groups. It calculates it for all possible combinations of groups and returns the minimum value.
}
\examples{

grouping_exact=list(c(1,2,3,4,5),c(6,7),c(8,9))
grouping_obtained=list(c(1,3,7),c(2,4,6),c(8,9,5))

Number_of_failes(grouping_exact, grouping_obtained)
}
