% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE.R
\name{MSE}
\alias{MSE}
\title{Function to compute the multiscale entropy(MSE)}
\usage{
MSE(x, tau, m, r, I)
}
\arguments{
\item{x}{a numeric vector, with data for a regularly spaced time series. NA's are not allowed (because the C program is not set up to handle them).}

\item{tau}{a vector of scale factors to use for MSE.  Scale factors are positive integers that specify bin size for the MSE algorithm:
the number ofconsecutive observations in 'x' that form a bin and are averaged in the first step of the algorithm.
Must be a sequence of equally-spaced integers starting at 1. The largest value must still leave a sufficient number of bins to estimate entropy.}

\item{m}{a positive integers giving the window size for the entropy calculations in the second step of the algorithm, Typical values are 1, 2, or 3.}

\item{r}{a positive value of coefficients for similarity thresholds, such as r=0.15, r*sd(y) must be in the same units as 'x'.
Averages in two bins are defined to be similar if they differ by 'r*sd(y)' or less. NOTE: Currently only a single threshold is allowed per run; i.e.,'r' must be a scalar.}

\item{I}{the maximal number of points to be used for calculating MSE}
}
\value{
A data frame with with one row for each combination of 'tau', 'm' and 'rSD'. Columns are "tau", "m", "rSD", and "SampEn" (the calculated sample entropy).
The data frame will also have an attribute "SD", the standard deviation of 'x'. rSD = r*sd(y)
}
\description{
function to perform a multiscale entropy (MSE) analysis of a regularly spaced time series.
Return the results as an R data frame. Methods derived from Madalena Costa(2002) "Multiscale entropy analysis of complex physiologic time series" <doi:10.1103/PhysRevLett.89.068102>.
}
\examples{
data("TestData") # load Data from TestData dataset
oldoptions <- options(scipen=999)
Fs <- 50 # sampling frequency
scale_raw <- seq(1,90,by=2)
MSER <-  MSE(Data[1:10000,2], tau=scale_raw, m=2,
            r=0.15, I=40000)
print(MSER)
options(oldoptions)

}
\references{
Zhang T, Dong X, Chen C, Wang D, Zhang XD. RespirAnalyzer: an R package for continuous monitoring of respiratory signals.
}
