% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getShares.R
\name{getShares}
\alias{getShares}
\title{Extract list of users who publicly shared a public Facebook post}
\usage{
getShares(post, token, n = 100)
}
\arguments{
\item{post}{A post ID}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{n}{numeric, maximum number of shares to return.}
}
\description{
\code{getShares} retrieves a list of posts that correspond to shares
of a post on a public Facebook page. Only public posts by users who have
granted authorization to the app used to authenticate.
}
\details{
\code{getShares} returns a data frame with four variables: \code{from_name}
(the name of the user who shared the post), \code{from_id} (the ID of the
user who shared the post), \code{shared_time} (the time at which the post
was shared), and \code{id} (the ID of the new post).

For more information on why not all shared posts are returned, see here:
\url{https://developers.facebook.com/bugs/1404733043148335/}
}
\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
## Getting information about Facebook's Facebook Page
load("fb_oauth")
fb_page <- getPage(page="facebook", token=fb_oauth)
## Getting shares of most recent post
shares <- getShares(post=fb_page$id[1], n=2000, token=fb_oauth)
}

}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
\seealso{
\code{\link{getPage}}, \code{\link{getPost}}
}

