% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchApp.R
\name{launchApp}
\alias{launchApp}
\title{Launch Shiny Application for FSSA Demonstration}
\usage{
launchApp(type = "ufssa")
}
\arguments{
\item{type}{Type of FSSA with options of \code{type = "ufssa"} or \code{type = "mfssa"}.}
}
\value{
A shiny application object.
}
\description{
This function launches a Shiny app to facilitate the understanding of univariate
or multivariate Functional Singular Spectrum Analysis (\code{\link{fssa}}). The app
enables users to perform univariate or multivariate FSSA on various data types,
including simulated and real data provided by the server. Users can also upload
their own data. The app supports simultaneous comparisons of different methods,
such as multivariate vs. univariate FSSA, and allows users to select the number
and types of basis elements used for estimating Functional Time Series
(\code{\link{funts}}) objects. It offers plotting capabilities for both
 \code{\link{funts}} and \code{\link{fssa}}.
}
\examples{
\dontrun{
launchApp()
}

}
