% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params}
\alias{params}
\title{utility to build the Fuzzy Coco parameters data structure}
\usage{
params(
  nb_rules,
  nb_max_var_per_rule,
  max_generations = 100,
  max_fitness = 1,
  nb_cooperators = 2,
  influence_rules_initial_population = FALSE,
  influence_evolving_ratio = 0.8,
  ivars.nb_sets = 3,
  ivars.nb_bits_vars = NA_integer_,
  ivars.nb_bits_sets = NA_integer_,
  ivars.nb_bits_pos = NA_integer_,
  ovars.nb_sets = 3,
  ovars.nb_bits_vars = NA_integer_,
  ovars.nb_bits_sets = NA_integer_,
  ovars.nb_bits_pos = NA_integer_,
  rules.pop_size = 100,
  rules.elite_size = 5,
  rules.cx_prob = 0.5,
  rules.mut_flip_genome = 0.5,
  rules.mut_flip_bit = 0.025,
  mfs.pop_size = 100,
  mfs.elite_size = 5,
  mfs.cx_prob = 0.5,
  mfs.mut_flip_genome = 0.5,
  mfs.mut_flip_bit = 0.025,
  output_vars_defuzz_thresholds = NA,
  metricsw.sensitivity = 1,
  metricsw.specificity = 0.8,
  metricsw.accuracy = 0,
  metricsw.ppv = 0,
  metricsw.rmse = 0,
  metricsw.rrse = 0,
  metricsw.rae = 0,
  metricsw.mse = 0,
  metricsw.distanceThreshold = 0,
  metricsw.distanceMinThreshold = 0,
  metricsw.nb_vars = 0,
  metricsw.overLearn = 0,
  metricsw.true_positives = 0,
  metricsw.false_positives = 0,
  metricsw.true_negatives = 0,
  metricsw.false_negatives = 0,
  features_weights = list()
)
}
\arguments{
\item{nb_rules}{(mandatory) the number of rules in the fuzzy system}

\item{nb_max_var_per_rule}{(mandatory) The maximum number of antecedents (input variables) to use in each rule.}

\item{max_generations, max_fitness, nb_cooperators, influence_rules_initial_population, influence_evolving_ratio, ivars.nb_sets, ivars.nb_bits_vars, ivars.nb_bits_sets, ivars.nb_bits_pos, ovars.nb_sets, ovars.nb_bits_vars, ovars.nb_bits_sets, ovars.nb_bits_pos, rules.pop_size, rules.elite_size, rules.cx_prob, rules.mut_flip_genome, rules.mut_flip_bit, mfs.pop_size, mfs.elite_size, mfs.cx_prob, mfs.mut_flip_genome, mfs.mut_flip_bit, output_vars_defuzz_thresholds, metricsw.sensitivity, metricsw.specificity, metricsw.accuracy, metricsw.ppv, metricsw.rmse, metricsw.rrse, metricsw.rae, metricsw.mse, metricsw.distanceThreshold, metricsw.distanceMinThreshold, metricsw.nb_vars, metricsw.overLearn, metricsw.true_positives, metricsw.false_positives, metricsw.true_negatives, metricsw.false_negatives, features_weights}{cf \href{https://github.com/Lonza-RND-Data-Science/fuzzycoco/blob/main/PARAMS.md}{fuzzycoco doc}}
}
\value{
a nested named list
}
\description{
utility to build the Fuzzy Coco parameters data structure
}
\examples{
pms <- params(
 nb_rules = 2, nb_max_var_per_rule = 3, rules.pop_size = 20, mfs.pop_size = 20, 
 ivars.nb_sets = 3, ivars.nb_bits_vars = 3,  ivars.nb_bits_sets = 2, ivars.nb_bits_pos = 8, 
 ovars.nb_sets = 3, ovars.nb_bits_vars = 1, ovars.nb_bits_sets = 2, ovars.nb_bits_pos = 8, 
 metricsw.sensitivity = 0, metricsw.specificity = 0, metricsw.rmse = 1,
 output_vars_defuzz_thresholds = list(3, 17)
)
}
