% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture_methods.R
\name{loglkd}
\alias{loglkd}
\title{S3 method for mixture model : log-likelihood}
\usage{
loglkd(object, newdata)
}
\arguments{
\item{object}{a fitted mixture model of \code{riemmix} class.}

\item{newdata}{data of \eqn{n} objects (vectors, matrices) that can be wrapped by one of \code{wrap.*} functions in the \pkg{Riemann} package.}
}
\value{
the log-likelihood.
}
\description{
Given a fitted mixture model \eqn{f(x)} and observations \eqn{x_1, \ldots, x_n \in \mathcal{M}}, compute the log-likelihood
\deqn{L = \log \prod_{i=1}^n f(x_i) = \sum_{i=1}^n \log f(x_i)}.
}
\examples{
\donttest{
# ---------------------------------------------------- #
#            FIT A MODEL & APPLY THE METHOD
# ---------------------------------------------------- #
# Load the 'city' data and wrap as 'riemobj'
data(cities)
locations = cities$cartesian
embed2    = array(0,c(60,2)) 
for (i in 1:60){
   embed2[i,] = sphere.xyz2geo(locations[i,])
}

# Fit a model
k3 = moSN(locations, k=3)

# Evaluate
newloglkd = round(loglkd(k3, locations), 3)
print(paste0("Log-likelihood for K=3 model fit : ", newloglkd))
}

}
\concept{utility}
