% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{FGn}
\alias{FGn}
\title{Simulation of fractional Gaussian noise}
\usage{
FGn(H, t_start = 0, t_end = 1, N = 1000, plot = FALSE)
}
\arguments{
\item{H}{Hurst parameter which lies between 0 and 1.}

\item{t_start}{Initial time point.}

\item{t_end}{Terminal time point.}

\item{N}{Number of time steps on the interval \code{[t_start,t_end]}.
Default set to 1000.}

\item{plot}{Logical: If \code{TRUE}, the realisation of the fractional Gaussian noise
is plotted in interactive sessions.}
}
\value{
A data frame where the first column is \code{t} and second
column is simulated values of the realisation of fractional Gaussian noise.
}
\description{
This function simulates a realisation of the fractional Gaussian noise over the
time interval \code{[t_start,t_end]} for a provided Hurst parameter.
}
\examples{
FGn(H=0.5,plot=TRUE)
}
\references{
Banna, O., Mishura, Y., Ralchenko, K., & Shklyar, S. (2019). Fractional Brownian motion:
Approximations and Projections. John Wiley & Sons. \doi{doi:10.1002/9781119476771.app3}.
}
\seealso{
\code{\link{FBm}}, \code{\link{Bm}}, \code{\link{GHBMP}}, \code{\link{Bbridge}}, \code{\link{FBbridge}}
}
