% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{Hurst}
\alias{Hurst}
\title{Statistical estimation of the Hurst function}
\usage{
Hurst(X, N = 100, Q = 2, L = 2)
}
\arguments{
\item{X}{Data frame where the first column is a numeric time sequence and the second the values of the process or time series.}

\item{N}{Number of sub-intervals on which the estimation is performed on. Default is set to 100 sub-intervals.}

\item{Q}{Fixed integer greater than or equal to 2. Default is set to 2.}

\item{L}{Fixed integer greater than or equal to 2. Default is set to 2.}
}
\value{
A data frame of where the first column is a time sequence and second column is estimated values of the Hurst function.
}
\description{
This function computes statistical estimates for the Hurst function.
}
\details{
Statistical estimation of the Hurst function is done based on the results of Ayache, A.,
& Bouly, F. (2023). The estimator is built through generalized quadratic variations
of the process associated with its increments.
}
\note{
Since these are estimators of local characteristics, reliable results can only be obtained when a sufficiently large number of points is used.
}
\examples{
\donttest{
#Hurst function of a multifractional process simulated using GHBMP function
T <- seq(0, 1, by = (1/2)^10)
H <- function(t) {return(0.5 - 0.4 * sin(6 * 3.14 * t))}
X <- GHBMP(T, H)
Hurst(X)
}

#Hurst function of a fractional Browian motion simulated using FBm
X <- FBm(H = 0.5, x_start = 0, t_start = 0, t_end = 2, N = 1000)
Hurst(X)

}
\references{
Ayache, A. and Bouly, F. (2023). Uniformly and strongly consistent estimation for
the random Hurst function of a multifractional process. Latin American Journal of
Probability and Mathematical Statistics, 20(2):1587–1614. \doi{doi:10.30757/alea.v20-60}.
}
\seealso{
\code{\link{LFD}}, \code{H_LFD}, \code{\link{plot.mp}}, \code{\link{plot_tsest}}, \code{\link{plot.H_LFD}}
}
