% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_box_plot.R
\name{create_box_plot}
\alias{create_box_plot}
\title{create_box_plot}
\usage{
create_box_plot(
  df = NULL,
  aes_x = NULL,
  aes_y = NULL,
  aes_color = NULL,
  aes_fill = NULL,
  aes_label = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = NULL,
  y_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  rot_x_tic_angle = 0,
  rot_y_tic_label = FALSE,
  box_fill = NA,
  box_color = "black",
  box_line_width = 0.5,
  box_alpha = 1,
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_decimals = 0,
  y_scientific = FALSE,
  axis_text_size = 11,
  do_coord_flip = FALSE,
  show_legend = TRUE,
  panel_color = "white",
  panel_border_color = "black",
  legend_pos = "top",
  legend_key_width = 0.7,
  legend_key_height = 0.7,
  legend_key_backgrd = "white",
  show_major_grids = TRUE,
  show_minor_grids = TRUE,
  ol_color = "black",
  ol_fill = "black",
  ol_size = 1.5,
  ol_shape = 19,
  ol_stroke = 0.5,
  ol_alpha = NULL,
  order_by_median = NULL,
  silent_NA_warning = FALSE,
  png_file_path = NULL,
  png_width_height = c(480, 480)
)
}
\arguments{
\item{df}{The target data frame for the density chart.}

\item{aes_x}{An optional factor variable name from 'df' that sets the x axis variable.
Multiple box plots will be displayed along the x axis if this argument is set.}

\item{aes_y}{A required variable name from 'df' that sets the y axis variable.}

\item{aes_color}{Sets the variable name from 'df' for the aesthetic mapping for color.}

\item{aes_fill}{Sets the variable name from 'df' for the aesthetic mapping for fill.}

\item{aes_label}{Sets the variable name from 'df' whose value will to be displayed corresponding
to the 'aes_y' outliers.}

\item{title}{A string that sets the overall title.}

\item{subtitle}{A string that sets the overall subtitle}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} (the default)  then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If \code{NULL} (the default)  then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic labels. When x tic labels are long,
a value of 40 for this argument usually works well.}

\item{rot_y_tic_label}{A logical which if TRUE rotates the y tic labels 90 degrees for enhanced readability.}

\item{box_fill}{A string that sets the fill color attribute for the box plot.}

\item{box_color}{A string that sets the color attribute for the box plot.}

\item{box_line_width}{A numeric that sets the size attribute of the box line width.}

\item{box_alpha}{A numeric that set the alpha component attribute to 'box_color'.}

\item{y_limits}{A numeric 2 element vector that sets the minimum and maximum for the y axis.
Use \code{NA} to refer to the existing minimum and maximum.}

\item{y_major_breaks}{A numeric vector or function that defines the exact major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that defines the exact minor tic locations along the y axis.}

\item{y_decimals}{A numeric that sets the number of decimal places for y-tic labels.}

\item{y_scientific}{A logical which if \code{TRUE} will put the y-tic labels in scientific notation.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}

\item{do_coord_flip}{A logical which if \code{TRUE} will flip the x and y axis'.}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}

\item{legend_pos}{A string that sets the legend position. Acceptable values are
"top", "bottom", "left", "right".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color. The default is "white".}

\item{show_major_grids}{A logical that controls the appearance of major grids.}

\item{show_minor_grids}{A logical that controls the appearance of minor grids.}

\item{ol_color}{A string that sets the outlier color.}

\item{ol_fill}{A string that sets the outlier fill.}

\item{ol_size}{A numeric that set the outlier size.}

\item{ol_shape}{A string that set the outlier shape.}

\item{ol_stroke}{A numeric that sets the outlier shape line width.}

\item{ol_alpha}{A numeric that sets the outlier alpha for color.}

\item{order_by_median}{A string which will order the plot of 'aes_x' factor levels/categories by the 'aes_y' medians.
Acceptable values are "asc" or "desc". Note that the optional argument 'aes_x' must not be \code{NULL}.}

\item{silent_NA_warning}{A logical that controls the appearance of a console warning when Na's
are removed.}

\item{png_file_path}{A character string with the directory and file name to produce
a png image of the plot.}

\item{png_width_height}{A numeric vector that sets the width and height of the png image in pixels. The
default is c(480,480).  There are 37.8 pixels in a centimeter.}
}
\value{
A ggplot class object.
}
\description{
Function wraps around ggplot2 geom_boxplot to create a box plot.
}
\examples{
library(ggplot2)
library(data.table)
library(RplotterPkg)

RplotterPkg::create_box_plot(
  df = RplotterPkg::organdata,
  aes_x = "country",
  aes_y = "donors",
  aes_label = "donors",
  order_by_median = "desc",
  y_limits = c(5,35),
  y_major_breaks = seq(5, 35, 5),
  title = "Organ Donation Rate per Million",
  subtitle = "Showing outlier rates",
  x_title = "Country",
  y_title = "Donor Rate",
  do_coord_flip = TRUE,
  box_color = "purple",
  box_line_width = 0.8,
  rot_y_tic_label = TRUE,
  ol_color = "red",
  ol_size = 1.5
)

}
