% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_gibbs_samples_statistics.R
\name{RprobitB_gibbs_samples_statistics}
\alias{RprobitB_gibbs_samples_statistics}
\alias{print.RprobitB_gibbs_samples_statistics}
\title{Create object of class \code{RprobitB_gibbs_samples_statistics}}
\usage{
RprobitB_gibbs_samples_statistics(gibbs_samples, FUN = list(mean = mean))

\method{print}{RprobitB_gibbs_samples_statistics}(x, true = NULL, digits = 2, ...)
}
\arguments{
\item{gibbs_samples}{An object of class \code{RprobitB_gibbs_samples}, which generally is located
as object \code{gibbs_samples} in an \code{RprobitB_model} object.}

\item{FUN}{A (preferably named) list of functions that compute parameter statistics
from the Gibbs samples, for example
\itemize{
\item \code{mean} for the mean,
\item \code{sd} for the standard deviation,
\item \code{min} for the minimum,
\item \code{max} for the maximum,
\item \code{median} for the median,
\item \code{function(x) quantile(x, p)} for the \code{p}th quantile,
\item \code{R_hat} for the Gelman-Rubin statistic.
}}

\item{true}{Either \code{NULL} or an object of class \code{RprobitB_parameter}.}
}
\value{
An object of class \code{RprobitB_gibbs_samples_statistics}, which is a list
of statistics from \code{gibbs_samples} obtained by applying the elements of
\code{FUN}.
}
\description{
This function creates an object of class
\code{RprobitB_gibbs_samples_statistics}.
}
\keyword{internal}
