% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repest_auxiliaries.R
\name{format_data_repest}
\alias{format_data_repest}
\title{Formatting target, by, and over variables for Rrepest.}
\usage{
format_data_repest(df, svy, x, by.over, user_na = F, ...)
}
\arguments{
\item{df}{(data frame) Data to analyze.}

\item{svy}{(string) Possible projects to analyse: PIAAC, PISA, TALISSCH, TALISTCH, etc.}

\item{x}{(string vector) Target variables.}

\item{by.over}{(string vector) Variables to break analysis by.}

\item{user_na}{(bool) TRUE → show nature of user defined missing values}

\item{...}{Optional arguments such as custom weights (cm.weights)}
}
\value{
Data frame with variables in numeric format for analysis.
}
\description{
Formatting target, by, and over variables for Rrepest.
}
\examples{
df1 <- format_data_repest(df_pisa18, "PISA", "pv1math", "cnt")
df2 <- format_data_repest(df_pisa18, "PISA", "pv1math", c("cnt","st004d01t"))
df3 <- format_data_repest(df_pisa18, "PISA", "pv1math", c("cnt","st004d01t","iscedl"))
df4 <- format_data_repest(df_talis18, "TALISTCH", "tt3g02", "cntry", isced = 2)
}
