% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC.R
\name{Rule4}
\alias{Rule4}
\title{Rule 4}
\usage{
Rule4(x, nPoints = 14, convention = 1, ...)
}
\arguments{
\item{x}{Numerical vector}

\item{nPoints}{Sequence of consequtive points to be evaluated}

\item{convention}{Calculation according to 'minitab' or 'jmp' (see details)}

\item{...}{unspecified arguments of a function}
}
\value{
Vector of the same length as x
}
\description{
Fourteen or more points in a row alternate in direction, increasing then decreasing.
}
\details{
0 means: ok \cr
1 means: violation \cr

parameter convention is internally encoded as: 1 for 'minitab' and 2 for 'jmp' \cr

Difference in convention parameter is as follows: \cr
'minitab' - 15 or more points (14 changes of direction) in a row alternate in direction, increasing then decreasing \cr
'jmp' - 14 or more points (13 changes of direction) in a row alternate in direction, increasing then decreasing
}
\examples{
Rule4(x = rnorm(20), nPoints = 14,convention = 1)
}
