% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbi.R
\name{BlindingIndex}
\alias{BlindingIndex}
\title{Computes a simple index for blinding in randomized clinical trials.}
\usage{
BlindingIndex(
  n_AA,
  n_BA,
  n_AB,
  n_BB,
  tolerance = 1e-12,
  switch_point = 1e-12,
  conf.level = 0.95
)
}
\arguments{
\item{n_AA}{Number of patients in Group A guessing that they are in Group A. A non-negative number, usually an integer.}

\item{n_BA}{Number of patients in Group A guessing that they are in Group B. A non-negative number, usually an integer.}

\item{n_AB}{Number of patients in Group B guessing that they are in Group A. A non-negative number, usually an integer.}

\item{n_BB}{Number of patients in Group B guessing that they are in Group B. A non-negative number, usually an integer.

Alternatively, one can pass the first four arguments as a single 2x2 table,
that is, as.table(cbind(c(n_AA, n_BA), c(n_AB, n_BB))).}

\item{tolerance}{Tolerance for the `stats::uniroot' function.}

\item{switch_point}{A technical detail. A (very small) positive number.}

\item{conf.level}{confidence level.}
}
\value{
\item{est}{Estimate}
 \item{lwr.ci}{Lower end of CI}
 \item{upr.ci}{Upper end of CI}
 \item{p.value}{p-value dual to the Wilson CI method}
 \item{z}{z-value corresponding to the p-value}
}
\description{
This routine takes the entries from a 2x2 table as the arguments
and returns the estimate for the difference of the probabilities p_A-p_B
along with the Newcombe-Wilson-CI. It also finds a p-value dual to the Newcombe-Wilson method.
For more details, see Petroff, Bacak, Dagres, Dilk, Wachter: A simple blinding index for randomized controlled trials. Contemp Clin Trials Commun. 2024 Nov 26;42:101393. doi: 10.1016/j.conctc.2024.101393. PMID: 39686958.
}
\examples{
BlindingIndex(50, 50, 50, 50)
}
