% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_index.R
\name{create_index}
\alias{create_index}
\title{Create the indexes on table}
\usage{
create_index(conn, db_table, columns)
}
\arguments{
\item{conn}{(\code{DBIConnection})\cr
A connection to a database.}

\item{db_table}{(\verb{id-like object(1)})\cr
A table specification (coercible by \code{id()}).}

\item{columns}{(\code{character()})\cr
The columns that should be unique.}
}
\value{
NULL (called for side effects)
}
\description{
Create the indexes on table
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  conn <- get_connection()

  mt <- dplyr::copy_to(conn, dplyr::distinct(mtcars, .data$mpg, .data$cyl), name = "mtcars")
  create_index(conn, mt, c("mpg", "cyl"))

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
