% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreplot.R
\name{scoreplot}
\alias{scoreplot}
\title{scoreplot}
\usage{
scoreplot(
  X,
  pcamodel,
  obstag = matrix(0, nrow(X), 1),
  pcx = 1,
  pcy = 2,
  alpha = 0.05,
  plottitle = "Score plot\\n"
)
}
\arguments{
\item{X}{Matrix with the data to be displayed.}

\item{pcamodel}{List wiht the PCA model elements.}

\item{obstag}{Optional column vector of integers indicating the group of each
observation (\code{0} or \code{1}). Default value set to \code{matrix(0, nrow(X), 1)}.}

\item{pcx}{Optional integer with the number of the PC in the horizontal axis. Set to \code{1} by default.}

\item{pcy}{Optional integer with the number of the PC in the vertical axis. Set to \code{2} by default.}

\item{alpha}{Optional number between 0 and 1 expressing the type I risk assumed in the compuatation of the confidence ellipse,
set to \code{0.05} (5 \%) by default.}

\item{plottitle}{Optional string with the plot title. Set to \code{"Score plot"} by default.}
}
\value{
ggplot object with the generated score plot.
}
\description{
Returns the score plot providing a dataset and a pca model. Observations can
be identified by the obstag input argument.
}
\examples{
X <- as.matrix(X)
pcamodel.ref <- pcamb_classic(X[1:40,], 3, 0.05, "cent")
scoreplot(X, pcamodel.ref)
tags <- dotag(X[1:40,], X[-c(1:40),])
scoreplot(X, pcamodel.ref, obstag = tags, pcx = 2, pcy = 3, alpha = 0.1, plottitle = "T-plot")
}
