% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_mutation_rate.R
\name{compute_mutation_rate}
\alias{compute_mutation_rate}
\title{Compute Scalable Mutation-Rate Vector}
\usage{
compute_mutation_rate(
  method = c("ScaI", "ScaII", "ScaIII"),
  beta_star,
  beta_init,
  L,
  N_chain
)
}
\arguments{
\item{method}{Character, one of "ScaI", "ScaII", "ScaIII".}

\item{beta_star}{Target parameter vector (binary or factor).}

\item{beta_init}{Current/initial parameter vector.}

\item{L}{Integer > 0, length of the parameter vector.}

\item{N_chain}{Integer > 1, number of parallel chains.}
}
\value{
List with components:
\item{Q}{Mutation-rate vector (length 2, r, or N_chain).}
\item{Q0}{Base mutation rate (scalar).}
\item{r}{Scalar, present only for ScaII - number of active components.}
\item{w}{Vector, present only for ScaIII - normalized random weights.}
}
\description{
Implements the three mutation-rate strategies (ScaI, ScaII, ScaIII)
described in the reference paper.
}
\examples{
beta_star <- c(1, 0, 1, 1, 0)
beta_init <- c(1, 1, 1, 0, 0)
compute_mutation_rate("ScaII", beta_star, beta_init, L = 5, N_chain = 8)

}
