% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalization.R
\name{internalization}
\alias{internalization}
\title{Motivation Internalization or Externalization Shares}
\usage{
internalization(intermediate_regulation, intrinsic_regulation,
  external_regulation)
}
\arguments{
\item{intermediate_regulation}{A required numeric vector of intermediate,
either identified or introjected, regulation subscale motivation scores. No
\code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf} values are allowed.}

\item{intrinsic_regulation, external_regulation}{Required numeric vectors of
intrinsic regulation and external regulation subscale motivation scores,
respectively. No \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf} values
are allowed.}
}
\value{
If the arguments \code{intermediate_regulation},
  \code{intrinsic_regulation}, and \code{external_regulation} are of required
  types, \code{internalization} returns a numeric vector containing the
  \eqn{2} named components \code{internal share} and \code{external share} of
  the \code{intermediate_regulation} type with respect to the extreme poles
  \code{intrinsic_regulation} and \code{external_regulation} of the theory.
  The returned object is of the class \code{share} and has the attribute
  \code{analysis} set to have the value \code{internalization}.
}
\description{
\code{internalization} computes the internalization or externalization shares
of an intermediate motivation regulation type with respect to the poles of
intrinsic regulation and external regulation as the reference system.
}
\details{
This function computes the shares of motivation internalization or
externalization pertaining to the notion of \emph{\dQuote{somewhat internal}}
and \emph{\dQuote{somewhat external}} on the self-determination theory
subscales of identified regulation and introjected regulation, as the
intermediate motivation regulation types---with respect to intrinsic
regulation and external regulation, the completely internal and completely
external motivation poles of the theory, respectively, as the reference
system spanned by these two base elements.

The argument \code{intermediate_regulation}, the target variable of the
constrained regression analysis, can be either identified regulation or
introjected regulation aggregate subscale motivation scores, and the
arguments \code{intrinsic_regulation} and \code{external_regulation}, the
predictor variables of the constrained regression analysis, do represent
aggregate motivation scores for the intrinsic regulation and external
regulation subscales, respectively. The function
\code{\link[quadprog]{solve.QP}} of the package \pkg{quadprog} is applied in
\code{internalization} to solve the self-determination theory related
(convex) quadratic program. For details, see \cite{Uenlue and Dettweiler
(2015)}.
}
\examples{
## attach dataset to search path (to use variable names)
attach(learning_motivation)

## internal share and external share of identified regulation
(idr <- internalization(identified, intrinsic, external))
## attribute value and class
attr(idr, "analysis")
class(idr)

## internal share and external share of introjected regulation
(ijr <- internalization(introjected, intrinsic, external))
## all attributes
attributes(ijr)
}
\references{
Uenlue, A. and Dettweiler, U. (2015) Motivation internalization
  and simplex structure in self-determination theory. \emph{Psychological
  Reports}, \bold{117}(3), 675--691. URL
  \url{https://doi.org/10.2466/14.PR0.117c25z1}.
}
\seealso{
The two other main functions of the package: \code{\link{simplex}}
  for motivation simplex structure analysis; \code{\link{sdi}} for the
  original and adjusted SDI or RAI index. See the methods associated with
  \code{internalization} as the constructor function:
  \code{\link{plot.share}}, the S3 method for plotting objects of the class
  \code{share}; \code{\link{print.share}}, the S3 method for printing objects
  of the class \code{share}. See also \code{\link{SDT-package}} for general
  information about this package.
}
\author{
Ali Uenlue <ali.uenlue@icloud.com>
}
\keyword{attribute}
\keyword{classes}
\keyword{models}
\keyword{regression}
