% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test62.R
\name{Test62}
\alias{Test62}
\title{Finding case deletions required to change fit metric using approximate method}
\usage{
Test62(
  df,
  model,
  threshold,
  fit,
  max_final,
  N,
  equalCons = 0L,
  measureTest = "cfi",
  fitThreshold = 0.9,
  highGood = TRUE,
  ...
)
}
\arguments{
\item{df}{A data frame containing the dataset.}

\item{model}{A specified SEM model.}

\item{threshold}{The threshold for percentage of data dropped.}

\item{fit}{The SEM object.}

\item{max_final}{The maximum number of influential data points to consider.}

\item{N}{The total number of data points.}

\item{equalCons}{Logical; whether equality constraints exist in the model. The approximate method can only be run if no equality constraints are present (default is 0).}

\item{measureTest}{The fit measurement name. Can be "cfi", "chisq", "tli", "rmsea".}

\item{fitThreshold}{The threshold of the fit measurement to be a "good" model. For example, for CFI (measureTest = "cfi"), this threshold can be 0.9.}

\item{highGood}{A boolean argument stating if the fit measurement is higher the better. For CFI, this argument is TRUE.}

\item{...}{Other arguments.}
}
\value{
A list of class \code{TestResult62} containing:
\item{methodname}{The name of the method used.}
\item{testindex}{The index of the test performed.}
\item{original_fit_value}{The original value of the fit measurement.}
\item{final_fit_value}{The fit value after dropping the influential points using the approximate method.}
\item{num_drops}{The number of data points dropped.}
\item{threshold_crossed}{Logical indicating whether the threshold was crossed.}
\item{final_drops}{The indices of the most influential data points dropped using the approximate method.}
\item{measureTest}{The name of the fit measurement used.}
\item{fitThreshold}{The threshold of the fit measurement used.}
\item{highGood}{Logical indicating if a higher value is better for the fit measurement.}
\item{appx_threshold_tally}{The tally value required to cross the threshold using the approximate method.}
\item{model_appx_threshold_final}{The final fit value after dropping points sufficient to cross the threshold using the approximate method.}
\item{max_final}{The maximum number of influential data points to consider.}
\item{N}{The total number of data points.}
\item{equalCons}{Logical indicating whether equality constraints exist in the model.}
}
\description{
Remove a fixed percentage of samples (determined by the approximate influence) at a time and refit the model to observe the change in the fit metric of interest. Use method 2 - Approximate Method.
}
\examples{
\donttest{
library(lavaan)
library(dplyr)
library(semfindr)
library(R.utils)


# Import data
df <- PoliticalDemocracy

# Build Model
model <- '
  # measurement model
  ind60 =~ x1 + x2 + x3
  dem60 =~ y1 + y2 + y3 + y4
  dem65 =~ y5 + y6 + y7 + y8
  # regressions
  dem60 ~ ind60
  dem65 ~ ind60 + dem60
  # residual correlations
  y1 ~~ y5
  y2 ~~ y4 + y6
  y3 ~~ y7
  y4 ~~ y8
  y6 ~~ y8
'

threshold <- 10

# Fit SEM model
fit <- lavaan::sem(model, data = df)
summary(fit)

# Compute max number of points to be dropped
max_final <- ceiling(threshold * nrow(df) / 100)
N <- nrow(df)

Test62_result <- Test62(df, model, threshold, fit, max_final, N, equalCons = 0L,
 measureTest = "cfi", fitThreshold = 0.9, highGood = TRUE)
summary(Test62_result)
}
}
