% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEset_to_network.R
\name{SEset_to_network}
\alias{SEset_to_network}
\title{Precision matrices from the SEset}
\usage{
SEset_to_network(
  SEmatrix,
  order.ref = NULL,
  order.mat = NULL,
  output = "raw",
  omega = NULL
)
}
\arguments{
\item{SEmatrix}{a \eqn{n \times p} matrix containing the SE-set. The output of
\code{\link{network_to_SEset}}}

\item{order.ref}{an optional character vector with variable names, the reference ordering
of the precision matrix.}

\item{order.mat}{a \eqn{n \times p} matrix of character strings,
defining the ordering of the matrix corresponding to each row of SEmatrix.
If NULL it is assumed that all orderings are included and they are generated using
\code{\link{order_gen}}}

\item{output}{Output as \code{"raw"} or \code{"summary"}. See value below}

\item{omega}{Comparision precision matrix, e.g. original input precision matrix to
\code{\link{network_to_SEset}}. Only necessary if \code{output = "summary"}}
}
\value{
If \code{output = "raw"}, a \eqn{n \times p} matrix of precision matrices
    stacked column-wise in \eqn{n} rows.
    If \code{output = "summary"} returns a list containing the bias, MSE and
    RMSE for each re-calculated precision matrix, relative to comparison \code{omega}
    matrix supplied.
}
\description{
Takes the SE-set and calculates for each weights matrix the corresponding
    precision matrix. Used to check the results of \code{\link{network_to_SEset}}
    to assess deviations from statistical equivalence induced due to rounding,
    thresholding, and numerical approximations.
}
\references{
\insertRef{ryan2019}{SEset}

    \insertRef{shojaie2010penalized}{SEset}

    \insertRef{bollen89sem}{SEset}
}
\seealso{
\code{\link{network_to_path}}, \code{\link{path_to_network}}
}
