% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propcal.R
\name{propcal}
\alias{propcal}
\title{Edge frequency in the SE-set}
\usage{
propcal(SEmatrix, names = NULL, rm_duplicate = TRUE, directed = TRUE)
}
\arguments{
\item{SEmatrix}{An \eqn{n \times p} matrix containing the SEset, where each row
represents a \eqn{p \times p} weights matrix stacked column-wise}

\item{names}{optional character vector containing dimension names}

\item{rm_duplicate}{Should duplicate weights matrices be removed from the SEset.
Defaults to TRUE.}

\item{directed}{If \code{FALSE}, the directionality of edges is ignored, and the output
reflects in what proportion of the SEset an edge of any direction is present.
If \code{TRUE}, the proportion is calculated seperately for edges of either direction.
Defaults to TRUE}
}
\value{
a \eqn{p \times p} matrix showing in what proportion particular edges are present.
   If directed=TRUE, elements ij denote the proportion of weights matrices containing a path
   from \eqn{X_j} to \eqn{X_i}. If directed=F, the output will be a symmetric matrix, with element ij
   denoting in what proprtion an edge of either direction connects \eqn{X_i} to \eqn{X_j}.
}
\description{
A function used to analyse the SEset results. Calculates the proportion of
    path models in a given SEset in which a particular edge is present
}
\references{
\insertRef{ryan2019}{SEset}
}
\seealso{
\code{\link{network_to_SEset}}
}
