% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_distribution.R
\name{r2_distribution}
\alias{r2_distribution}
\title{Compute Controllability Distribution in the SE-set}
\usage{
r2_distribution(SEmatrix, cormat, names = NULL, indices = NULL)
}
\arguments{
\item{SEmatrix}{An \eqn{n \times p} matrix containing the SEset, where each row
represents a \eqn{p \times p} weights matrix stacked column-wise}

\item{cormat}{A \eqn{p \times p} matrix containing the marginal covariances or correlations}

\item{names}{optional character vector containing dimension names}

\item{indices}{option vector of matrix indices, indicating which variables to compute the R^2 distribution for}
}
\value{
Returns an \eqn{n \times p} matrix of \eqn{R^2} values.
 For each member of the SE-set, this represents the variance explained in node \eqn{X_i} by it's parents
 in that weighted DAG.
}
\description{
A function used to analyse the SEset results. For each member of the SE-set,
calculate the proportion of explained variance in each child node, when
predicted by all of its parent nodes
}
\examples{
# first estimate the precision matrix
data(riskcor)
omega <- (qgraph::EBICglasso(riskcor, n = 69, returnAllResults = TRUE))$optwi
# qgraph method estimates a non-symmetric omega matrix, but uses forceSymmetric to create
# a symmetric matrix (see qgraph:::EBICglassoCore line 65)
omega <- as.matrix(Matrix::forceSymmetric(omega)) # returns the precision matrix

SEmatrix <- network_to_SEset(omega, digits=3)

r2set  <- r2_distribution(SEmatrix, cormat = riskcor, names = NULL, indices = c(1,3,4,5,6))
# Plot results
apply(r2set,2,hist)
# For ggplot format, execute
# r2set <- tidyr::gather(r2set)
}
\references{
\insertRef{ryan2019}{SEset}
    \insertRef{haslbeck2018well}{SEset}
}
\seealso{
\code{\link{network_to_SEset}, \link{find_parents}}
}
