% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAP_funcs.R
\name{shap.plot.dependence}
\alias{shap.plot.dependence}
\title{SHAP dependence and interaction plots}
\usage{
shap.plot.dependence(
  data_long,
  x,
  y = NULL,
  color_feature = NULL,
  data_int = NULL,
  dilute = FALSE,
  smooth = TRUE,
  size0 = NULL,
  add_hist = FALSE,
  add_stat_cor = FALSE,
  alpha = NULL,
  jitter_height = 0,
  jitter_width = 0,
  ...
)
}
\arguments{
\item{data_long}{the long format SHAP values from \code{\link{shap.prep}}}

\item{x}{which feature to show on x-axis, it will plot the feature value}

\item{y}{which shap values to show on y-axis, it will plot the SHAP value of
that feature. y is default to x, if y is not provided, just plot the SHAP
values of x on the y-axis}

\item{color_feature}{which feature value to use for coloring, color by the
feature value. If "auto", will select the feature "c" minimizing the
variance of the shap value given x and c, which can be viewed as a
heuristic for the strongest interaction.}

\item{data_int}{the 3-dimention SHAP interaction values array. if \code{data_int}
is supplied, y-axis will plot the interaction values of y (vs. x).
\code{data_int} is obtained from either \code{predict.xgb.Booster} or
\code{\link{shap.prep.interaction}}}

\item{dilute}{a number or logical, dafault to TRUE, will plot
\code{nrow(data_long)/dilute} data. For example, if dilute = 5 will plot
20\% of the data. As long as dilute != FALSE, will plot at most half the
data}

\item{smooth}{optional to add a \emph{loess} smooth line, default to TRUE.}

\item{size0}{point size, default to 1 if nobs<1000, 0.4 if nobs>1000}

\item{add_hist}{whether to add histogram using \code{ggMarginal}, default to
TRUE. But notice the plot after adding histogram is a \code{ggExtraPlot} object
instead of \code{ggplot2} so cannot add \code{geom} to that anymore. Turn the
histogram off if you wish to add more \code{ggplot2} geoms}

\item{add_stat_cor}{add correlation and p-value from \code{ggpubr::stat_cor}}

\item{alpha}{point transparancy, default to 1 if nobs<1000 else 0.6}

\item{jitter_height}{amount of vertical jitter (see hight in \code{geom_jitter})}

\item{jitter_width}{amount of horizontal jitter (see width in \code{geom_jitter}). Use values close to 0, e.g. 0.02}

\item{...}{additional parameters passed to \code{geom_jitter}}
}
\value{
be default a \code{ggplot2} object, based on which you could add more geom
layers.
}
\description{
Creates scatter plots showing the relationship between feature values (x-axis)
and SHAP values (y-axis). Can display:
\itemize{
\item Simple dependence: how feature values affect predictions
\item Colored by another feature: to explore interactions
\item Interaction effects: when \code{data_int} is provided, shows
pairwise SHAP interaction values
}
}
\examples{
# Example: SHAP dependence plots

# 1. Simple dependence plot: SHAP values vs feature values
shap.plot.dependence(data_long = shap_long_iris, x="Petal.Length",
                     add_hist = TRUE, add_stat_cor = TRUE)

# 2. Show different SHAP values on y-axis
shap.plot.dependence(data_long = shap_long_iris, x="Petal.Length",
                           y = "Petal.Width")

# 3. Color by another feature's values
shap.plot.dependence(data_long = shap_long_iris, x="Petal.Length",
                           color_feature = "Petal.Width")

# 4. Customize x, y, and color features
shap.plot.dependence(data_long = shap_long_iris, x="Petal.Length",
                           y = "Petal.Width", color_feature = "Petal.Width")

# 5. Additional options: histogram, smooth line, data dilution
shap.plot.dependence(data_long = shap_long_iris, x="Petal.Length",
                     y = "Petal.Width", color_feature = "Petal.Width",
                     add_hist = TRUE, smooth = FALSE, dilute = 3)

# Create multiple plots at once
plot_list <- lapply(names(iris)[2:3], shap.plot.dependence, data_long = shap_long_iris)

# SHAP interaction effect plot
# First, prepare the model and interaction data
X_iris = as.matrix(iris[,1:4])
y_iris = as.numeric(iris[[5]]) - 1
dtrain = xgboost::xgb.DMatrix(data = X_iris, label = y_iris)
params = list(learning_rate = 1, min_split_loss = 0, reg_lambda = 0,
              objective = 'reg:squarederror', nthread = 1)
mod1 = xgboost::xgb.train(params = params, data = dtrain,
                          nrounds = 1, verbose = 0)

# Get interaction SHAP values (two methods):
data_int <- shap.prep.interaction(xgb_model = mod1, X_train = X_iris)
# Or directly:
shap_int <- predict(mod1, X_iris, predinteraction = TRUE)

# Plot interaction effects (y-axis shows interaction values)
shap.plot.dependence(data_long = shap_long_iris,
                           data_int = shap_int_iris,
                           x="Petal.Length",
                           y = "Petal.Width",
                           color_feature = "Petal.Width")
}
