% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SR.R
\name{SR}
\alias{SR}
\title{Support Recovery Procedure}
\usage{
SR(X, Y)
}
\arguments{
\item{X}{n times p design matrix.}

\item{Y}{Response variable.}
}
\value{
The sets of active variables selected by the support recovery
procedure and the scaled Lasso.
}
\description{
This function implements the support recovery procedure in Zhang and Cheng (2017).
}
\references{
Zhang, X., and Cheng, G. (2017) Simultaneous Inference for High-dimensional
Linear Models, \emph{Journal of the American Statistical Association}, 112, 757-768.
}
\examples{
## The function is intended for large n and p.
## Use small p here for illustration purpose only.
n <- 100
p <- 10
s0 <- 7
set <- 1:s0
Sigma <- matrix(NA, p, p)
for (i in 1:p) Sigma[i,] <- 0.9^(abs(i-(1:p)))
X <- matrix(rnorm(n*p), n, p)
X <- t(t(chol(Sigma))\%*\%t(X))
beta <- rep(0,p)
beta[1:s0] <- runif(s0,1,2)
Y <- X\%*\%beta+rt(n,4)/sqrt(2)
SR(X, Y)
}
