#' A function that returns significant pathways.
#'
#' A function that returns significant pathways.
#' @param res_SMAHP Outputs from SMAHP
#' @return A data frame which includes the name of exposure and mediator with adjusted p-value from identified significant pathways.
#' @import data.table
#' @export
#' @examples
#' \donttest{
#' data(example_dat)
#' surv_dat <- example_dat$surv_dat
#' res_SMAHP <- SMAHP(example_dat$X, example_dat$M, example_dat$C, time = surv_dat$time,
#' status = surv_dat$status)
#' get_sig_pathway(res_SMAHP)
#' }

get_sig_pathway <- function(res_SMAHP){
  m <- res_SMAHP$p_med_matrix
  pos <- which(m == 1, arr.ind = TRUE)
  if(nrow(pos) == 0){
    return(message("No mediation assocation detected!"))
  } else {
    tab <- list()
    for(i in 1:nrow(pos)){
      x_name <- rownames(m)[pos[i,1]]
      m_name <- colnames(m)[pos[i,2]]
      a_p <- res_SMAHP$p_adjusted_matrix
      p <- a_p[pos[i,1], m_name]
      tab[[i]] <- data.frame(X = x_name, M = m_name, adjusted_pvalue = p)
    }
    final_tab <- rbindlist(tab)
    return(final_tab)
  }
}
