# Load and process the data to run SOHPIE
data(example_dat)
surv_dat <- example_dat$surv_dat
res_SMAHP <- SMAHP(example_dat$X, example_dat$M, example_dat$C, time = surv_dat$time, status = surv_dat$status)

# Create a function to check the sign of p-values
# and adjusted p-values:
sign_check <- function(pval) {
  if (sum(pval < 0, na.rm = TRUE) > 0) {
    return("ERROR: Negative p-values")
  } else {
    return("No negative p-values")
  }
}

# A function to check if p_final_matrix and p_adjusted_matrix have any negative p-values:
test_that("Check any negative p-values after SMAHP", {
  expect_equal(sign_check(res_SMAHP$p_final_matrix), "No negative p-values")
  expect_equal(sign_check(res_SMAHP$p_adjusted_matrix), "No negative p-values")
})

# Use testthat to check if p_med_matrix return any missing or NA:
test_that("Check the missingness after SMAHP", {
  expect_false(any(is.na(res_SMAHP$p_med_matrix)))
})
