% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_parameter.R
\name{compute_parameter}
\alias{compute_parameter}
\title{Estimate Nuisance Parameters for Semi-Supervised ATE Estimation}
\usage{
compute_parameter(nfold, Y, A, X, S, W, foldid, R, cf_model, custom_model_fun)
}
\arguments{
\item{nfold}{Integer. Number of cross-fitting folds.}

\item{Y}{Numeric vector. Outcome variable. Can contain \code{NA}s for unlabelled observations.}

\item{A}{Numeric vector. Treatment assignment indicator (0 or 1). Can contain \code{NA}s.}

\item{X}{Matrix or data frame. Covariates used for outcome and propensity score models.}

\item{S}{Matrix or data frame. Additional covariates used only in imputation models.}

\item{W}{Matrix or data frame. Combined set of covariates (typically \code{cbind(X, S)}).}

\item{foldid}{Integer vector. Fold assignments for cross-fitting.}

\item{R}{Binary vector. Label indicator: 1 = labelled (observed \code{A} and \code{Y}), 0 = unlabelled.}

\item{cf_model}{Function. A user-supplied cross-fitting wrapper function (e.g., based on Super Learner or other learners).}

\item{custom_model_fun}{A logical or function. If \code{NULL} or \code{FALSE}, bypasses adaptive-LASSO feature selection. Otherwise, enables two-stage tuning inside \code{compute_parameter()}.}
}
\value{
A named list of estimated nuisance parameters (each a numeric vector):
\describe{
\item{pi1.bs}{Estimated propensity score \eqn{P(A = 1 \mid X)}.}
\item{pi0.bs}{Estimated propensity score \eqn{P(A = 0 \mid X)} (computed as \code{1 - pi1.bs}).}
\item{mu1.bs}{Estimated outcome regression \eqn{E[Y \mid A = 1, X]}.}
\item{mu0.bs}{Estimated outcome regression \eqn{E[Y \mid A = 0, X]}.}
\item{cap_pi1.bs}{Estimated imputed propensity score \eqn{P(A = 1 \mid W)}.}
\item{cap_pi0.bs}{Estimated imputed propensity score \eqn{P(A = 0 \mid W)} (computed as \code{1 - cap_pi1.bs}).}
\item{m1.bs}{Estimated imputed outcome regression \eqn{E[Y \mid A = 1, W]}.}
\item{m0.bs}{Estimated imputed outcome regression \eqn{E[Y \mid A = 0, W]}.}
}
}
\description{
Computes nuisance functions including conditional expectations and propensity scores
using cross-fitting, separately for labelled and unlabelled data. These estimates
are essential inputs for doubly robust or semi-supervised average treatment effect (ATE) estimators.
}
\details{
This function applies cross-fitting to estimate all required nuisance functions for
semi-supervised or doubly robust ATE estimators. Separate models are fit for the
labelled dataset and the full dataset (for imputation).
}
\seealso{
\code{\link{cf}}
}
