% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultivariateRandomGenerator.R
\name{mgetDist}
\alias{mgetDist}
\title{Multivariate Random Observations Generetor}
\usage{
mgetDist(
  n,
  nv,
  mu = 0,
  sigma = NULL,
  correlation = 0,
  s = NULL,
  dists = NULL,
  dists.par = NULL
)
}
\arguments{
\item{n}{scalar. Number of observations to be generated.}

\item{nv}{scalar. Number of variables to be generated.}

\item{mu}{scalar. Expected value of the desired distribution.}

\item{sigma}{scalar. Standard deviation of the desired distribution.}

\item{correlation}{scalar. Corralation between variables.}

\item{s}{matrix. Correlation matrix of the variables}

\item{dists}{list.  Select the}

\item{dists.par}{matrix  For each variable (column), specify
\itemize{
  \item{\code{par.location}: Location parameter of the desired distribution. Default 0.}
  \item{\code{par.scale}: Scale parameter of the desired distribution. Default 1.}
  \item{\code{par.shape}: Shape parameter of the desired distribution, Default 1.}
}
The number of columns must be the same as the number of variables.}
}
\value{
A matrix \code{x} with \code{n} observations generated following the selected distribution with its parameters.
}
\description{
Multivariate Random observations generator selected from several distributions with user defined mean and variance.
}
\examples{
mgetDist(n=5, nv=2, dists=c("Normal", "Normal"),dists.par= matrix(c(0,1,1,0,1,1), ncol=2))
}
