% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSOA_LiuLiut.R
\name{OSOA_LiuLiut}
\alias{OSOA_LiuLiut}
\title{Strong Orthogonal Arrays of Strength t using the method of Liu and Liu}
\usage{
OSOA_LiuLiut(oa, t = NULL, m = NULL, permlist = NULL, random = TRUE)
}
\arguments{
\item{oa}{matrix or data.frame that contains an ingoing symmetric OA. Levels must be denoted as 0 to s-1 or as 1 to s.}

\item{t}{strength of \code{oa}.  If \code{NULL} (default), \code{t} will be
determined.  \code{t} can be chosen smaller than the input strength if
additional columns are desired.}

\item{m}{desired number of columns.  Defaults to the maximum possible.}

\item{permlist}{a list of length m of lists of length 1 of permutations of the levels}

\item{random}{a logical (a random draw of permutations is used if \code{permlist} is \code{NULL})}
}
\value{
an orthogonal array
}
\description{
Strong Orthogonal Arrays of Strength t using the method of Liu and Liu
}
\details{
Suitable OAs for argument \code{oa} can e.g. be constructed with OA creation functions
from package \pkg{lhs} or can be obtained from arrays listed in R package \pkg{DoE.base}.
}
\references{
Liu and Liu (2015)
}
\keyword{internal}
