% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql_format.R
\name{sql_format}
\alias{sql_format}
\title{Format an SQL Query}
\usage{
sql_format(
  query,
  indent = 2L,
  uppercase = TRUE,
  lines_between_queries = 1L,
  ignore_case_convert = NULL
)
}
\arguments{
\item{query}{A character string containing the SQL query to format.}

\item{indent}{An integer specifying the number of spaces for indentation
(default: 2).}

\item{uppercase}{A logical value indicating whether SQL keywords should
be converted to uppercase (default: TRUE).}

\item{lines_between_queries}{An integer specifying the number of blank
lines between queries (default: 1).}

\item{ignore_case_convert}{A logical value indicating whether to
case conversion (default: NULL).}
}
\value{
A formatted SQL query as a character string.
}
\description{
This function formats an SQL query based on various styling options.
}
\examples{
formatted_query <- sql_format("SELECT * FROM users WHERE id = 1")
cat(formatted_query)

}
