#' Body temperatures
#'
#' Body temperature (in degrees C and F) for people.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 130 rows (each person) and 4 columns:
#' \describe{
#'   \item{BodyTemp}{The measured body temperature, in degrees F, as given}
#'   \item{Gender}{One of \code{1} (males) or \code{2} (females)}
#'   \item{HeartRate}{Heart rate, in beats per minute}
#'   \item{BodyTempC}{The measured body temperature in degrees C; converted from degrees F}
#' }
#' @references
#' Wunderlich, C. 1868. Das Verhalten Der Eiaenwarme in Krankenheitem. 
#' Leipzig, Germany: Otto Wigard.
#' Mackowiak, Philip A., Steven S.Wasserman, and Myron M. Levine. 1992. 
#' A Critical Appraisal of 98.6 degrees F, the Upper Limit of the Normal 
#' Body Temperature, and Other Legacies of Carl Reinhold August Wunderlich. 
#' \emph{Journal of the American Medical Association} \bold{268} (12): 1578--80.
#' 
#' @source 
#' Allen, L. S. (1996). 
#' What's normal?--Temperature, gender, and heart rate. 
#' \emph{Journal of Statistics Education}, \bold{4}(2).
#' 
#' @usage 
#' data(BodyTemp)
#' 
#' @examples
#' plot(BodyTempC ~ factor(Gender), data = BodyTemp)
#' 

"BodyTemp"

