% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Perm.R
\docType{data}
\name{Perm}
\alias{Perm}
\title{Permeability of building materials}
\format{
A data frame with 81 rows (each sample) and 3 columns:
\describe{
  \item{Day}{The day of the data collection; \code{1} to \code{9}}
  \item{Mach}{The machine; one of \code{A}, \code{B} or \code{C}}
  \item{Perm}{The permeability of the sample, in seconds}
}
}
\source{
Bent Joergensen (1992) Exponential dispersion models and extensions: 
A review. 
\emph{International Statistical Review}, \bold{60}(1), 5--20
}
\usage{
data(Perm)
}
\description{
The permeability of building materials.
}
\examples{
plot(Perm ~ factor(Mach), data = Perm, ylab = "Permeability (seconds)", xlab = "Machine")

}
\references{
A. Hald (1952).
\emph{Statistical theory with engineering applications}. New York: Wiley.
}
\keyword{datasets}
