% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Throttle.R
\docType{data}
\name{Throttle}
\alias{Throttle}
\title{Throttle}
\format{
A data frame with 68 rows (each student) and 2 columns:
\describe{
  \item{ThrottleAngle}{The throttle angle, in degrees}
  \item{MAPvalue}{The manifold air pressure, as a fraction of the maximum value}
}
}
\source{
Amin, Arslan Ahmed, and Khalid Mahmood-ul-Hasan. 2019.
Robust Active Fault-Tolerant Control for Internal Combustion Gas Engine 
for Air-Fuel Ratio Control with Statistical Regression-Based Observer Model. 
\emph{Measurement and Control}, 0020294018823031
}
\usage{
data(Throttle)
}
\description{
Throttle and manifold air pressure.
}
\examples{
plot(MAPvalue ~ ThrottleAngle, data = Throttle, 
     ylab = "Manifold air pressure (\% of max)", 
     xlab = "Angle (degrees)")

}
\keyword{datasets}
