% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cyclones.R
\docType{data}
\name{Cyclones}
\alias{Cyclones}
\title{Cyclones in the Australian region}
\format{
A data frame with 37 rows (one per person) and 8 columns:
\describe{
  \item{Year}{The year}
  \item{Severe}{The number of severe cyclones recorded in the Australian region}
  \item{NonSevere}{The number of non-severe cyclones recorded in the Australian region}
  \item{Total}{The total number of cyclones recorded in the Australian region}
  \item{JFM}{the Ocean Nino Index, or ONI, averaged over the months January to March; a numeric vector}
  \item{AMJ}{the Ocean Nino Index, or ONI, averaged over the months April to June; a numeric vector}
  \item{JAS}{the Ocean Nino Index, or ONI, averaged over the months July to September; a numeric vector}
  \item{OND}{the Ocean Nino Index, or ONI, averaged over the months October to December; a numeric vector}
}
}
\source{
Dunn, Peter K., and Gordon K. Smyth. 2018. 
\emph{Generalized Linear Models with Examples in R}. Springer.
}
\usage{
data(Cyclones)
}
\description{
The number of cyclones (severe; non-severe) and the ONI.
}
\examples{
plot(Severe ~ OND, data = Cyclones, xlab = "OND", ylab = "Number severe cyclones")

}
\keyword{datasets}
