% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Soils.R
\docType{data}
\name{Soils}
\alias{Soils}
\title{Soil properties}
\format{
A data frame with 16 rows (each sample) and 12 columns:
\describe{
  \item{Sample}{An identifier}
  \item{Gravel}{The percentage of gravel in the sample}
  \item{Sand}{The percentage of sand in the sample}
  \item{Clay}{The percentage of clay in the sample}
  \item{PI}{Plasticity index (PI, a measure of the plasticity of the soil}
  \item{CBR}{The California Bearing Ratio, a measure of flexibility, as a percentage}
}
}
\source{
Talukdar, Dilip Kumar. 2014. 
A Study of Correlation Between California Bearing Ratio (CBR) Value 
with Other Properties of Soil.
\emph{International Journal of Emerging Technology and Advanced Engineering} 
\bold{4} (1): 559--62
}
\usage{
data(Soils)
}
\description{
Properties of soil and the California Bearing Ratio.
}
\examples{
plot(PI ~ Clay, data = Soils, xlab = "Clay percentage", ylab = "Plasticity index")

}
\keyword{datasets}
