% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{MF_preds}
\alias{MF_preds}
\title{MF_preds: A small set of prediction locations found in the Middle Fork Basin, Idaho.}
\format{
An object of class \code{sf} (inherits from \code{data.frame}) with 43 rows and 10 columns.
}
\source{
\code{MF_preds} are unpublished United States Forest Service data.
}
\usage{
MF_preds
}
\description{
\code{MF_preds} is an \code{sf} object with POINT geometry representing prediction locations and covariates distributed at 1km intervals throughout the Middle Fork Basin, Idaho, USA.
}
\details{
The \verb{sf data.frame} contains 43 point features and 9 columns:
\itemize{
\item COMID: Common identifier of an NHD feature or relationship
\item AREAWTMAP: Area weighted mean annual precipitation (mm) at lowermost
location on the line segment where the site resides
\item SLOPE: Slope of the line segment (cm/cm) where the site resides
\item ELEV_DEM: Elevation at the site based on a 30m DEM
\item FlowCMS: Average stream flow (cubic meters per sec) for August,
by year, from 1950-2010 across 9 USGS gauges in the region
\item AirMEANc: Average mean air temperature (C) from July 15 - August 31,
from 1980-2009 across 10 COOP air stations within the domain
\item AirMWMTc: Average maximum air temperature (C) from July 15 - August 31,
from 1980-2009 across 10 COOP air stations within the domain.
MWMT = maximum 7-day moving average of the maximum daily temperature
(i.e. maximum of all the 7-day maximums)
\item rcaAreaKm2: Reach contributing area (km2) for the downstream node of the edge feature the site resides on. RCA area is the land area draining directly into each line segment.
\item h2oAreaKm2: Watershed area (km2) for the downstream node of the edge feature the site resides on
}
}
\keyword{datasets}
