#' Compute Clayton Copula Parameter from Kendall's Tau
#'
#' Computes the Clayton copula dependence parameter based on Kendall's tau.
#'
#' @param tau Numeric, Kendall's tau correlation coefficient.
#' @return Numeric, estimated Clayton copula parameter.
#' @importFrom rootSolve uniroot.all
#' @export
#'
#' @examples clayton.theta(mean(cor(cbind(u[[1]], u[[2]], u[[3]]), method = "kendall")))
#'

clayton.theta <- function(tau){
  clayton.tau <- function(theta){(theta / (theta + 2)) - tau}
  theta_clayton <- rootSolve::uniroot.all(clayton.tau, c(0, 100))
  return(theta_clayton)
}
