% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPop.R
\name{aggPixelPreds}
\alias{aggPixelPreds}
\title{Helper function of \code{\link{pixelPopToArea}}}
\usage{
aggPixelPreds(
  Zg,
  Ng,
  areas,
  urban = target.pop.mat$urban,
  target.pop.mat = NULL,
  use.density = FALSE,
  stratify.by.urban = TRUE,
  normalize = use.density
)
}
\arguments{
\item{Zg}{nIntegrationPoint x nsim matrix of simulated response (population numerators) for each pixel and sample}

\item{Ng}{nIntegrationPoint x nsim matrix of simulated counts (population denominators) for each pixel and sample}

\item{areas}{nIntegrationPoint length character vector of areas (or subareas)}

\item{urban}{nIntegrationPoint length vector of indicators specifying whether or not pixels are urban or rural}

\item{target.pop.mat}{same as in \code{\link{simPopCustom}}}

\item{use.density}{whether to use population density as aggregation weights.}

\item{stratify.by.urban}{whether or not to stratify simulations by urban/rural classification}

\item{normalize}{if TRUE, pixel level aggregation weights within specified area are normalized to sum to 1. This produces an
average of the values in Zg rather than a sum. In general, should only be set to TRUE for smooth integrals of risk.}
}
\description{
Aggregates population from the
pixel level to the level of the area of interest.
}
