% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_simulation.R
\docType{data}
\name{example_svg_data}
\alias{example_svg_data}
\title{Example Spatial Transcriptomics Data}
\format{
A list with components:
\describe{
  \item{counts}{Integer matrix (200 genes × 500 spots) of raw counts}
  \item{logcounts}{Numeric matrix of log2(counts + 1)}
  \item{spatial_coords}{Numeric matrix (500 spots × 2) of x, y coordinates}
  \item{gene_info}{Data.frame with columns: gene, is_svg, pattern_type}
}
}
\source{
Simulated using \code{\link{simulate_spatial_data}}
}
\value{
A list containing the example dataset (see Format section).
}
\description{
A pre-generated example dataset for testing SVG detection methods.
Contains 500 spots and 200 genes, with 50 known SVGs.
}
\examples{
data(example_svg_data)
str(example_svg_data)

\donttest{
# Run SVG detection (requires RANN package)
if (requireNamespace("RANN", quietly = TRUE)) {
    results <- CalSVG_MERINGUE(
        example_svg_data$counts,
        example_svg_data$spatial_coords,
        verbose = FALSE
    )

    # Check accuracy
    truth <- example_svg_data$gene_info$is_svg
    detected <- results$p.adj < 0.05
    print(table(truth, detected))
}
}

}
