% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVMD.R
\name{sVMD}
\alias{sVMD}
\title{Spearman Variational Mode Decomposition}
\usage{
sVMD(
  series,
  alpha = 2000,
  tau = 0,
  DC = FALSE,
  init = 1,
  tol = 1e-07,
  threshold = 0.997,
  max_modes = 10,
  verbose = FALSE
)
}
\arguments{
\item{series}{The input time series signal to be decomposed.}

\item{alpha}{The balancing parameter of the data-fidelity constraint. Default is 2000.}

\item{tau}{Time-step of the dual ascent (pick 0 for noise-slack). Default is 0.}

\item{DC}{If TRUE, the first mode is put and kept at DC (0 frequency). Default is FALSE.}

\item{init}{Mode initialization (1 = all omegas start at 0). Default is 1.}

\item{tol}{Convergence tolerance criterion. Default is 1e-7.}

\item{threshold}{The correlation coefficient threshold to determine the optimal number of modes. Default is 0.997.}

\item{max_modes}{The maximum number of modes to consider. Default is 10.}

\item{verbose}{Logical, if TRUE, prints detailed messages about the decomposition process.}
}
\value{
Returns a list containing the optimal number of modes, reconstructed signal, and additional outputs from the VMD process:
\itemize{
  \item \code{optimal_K}: The optimal number of modes.
  \item \code{reconstructed_signal}: The reconstructed signal from the selected modes.
  \item \code{imfs}: Intrinsic Mode Functions (IMFs) obtained from SVMD.
  \item \code{u_hat}: Estimated envelopes of the modes.
  \item \code{omega}: Frequencies of the modes.
}
}
\description{
Optimal number of modes of Variational Mode Decomposition (VMD) using Spearman's rank correlation coefficient
}
\examples{
{
# Example data generation:
# Set the number of observations
N <- 300
# Set a random seed for reproducibility
set.seed(123)
# Generate random uniform values
rand_unif <- runif(n = N, min = 0, max = 1.0)
# Create the components of the time series
sig1 <- 6 * rand_unif
sig2 <- sin(8 * pi * rand_unif)  # Using sine function
sig3 <- 0.5 * sin(40 * pi * rand_unif)  # Using sine function
# Combine the components to form the final signal
signal <- sig1 + sig2 + sig3
# Apply the sVMD function to the signal
result <- sVMD(signal)
}
}
\references{
Yang, H., Cheng, Y., and Li, G. (2021). A denoising method for ship radiated noise based on Spearman variational mode decomposition, spatial-dependence recurrence sample entropy, improved wavelet threshold denoising, and Savitzky-Golay filter. Alexandria Engineering Journal, 60(3), 3379-3400
}
