% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{convert_SWIMw_to_SWIM}
\alias{convert_SWIMw_to_SWIM}
\title{Convert SWIMw to SWIM}
\usage{
convert_SWIMw_to_SWIM(object)
}
\arguments{
\item{object}{A \code{SWIMw} object}
}
\value{
A \code{SWIM} object containing:
    \itemize{
      \item \code{x}, a data.frame containing the data;
      \item \code{new_weights}, a list of functions, that applied to
  the \code{k}th column of \code{x}, generates the vectors of scenario
  weights. Each component corresponds to a different stress;
     \item \code{type = "VaR"};
     \item \code{specs}, a list, each component corresponds to
   a different stress and contains \code{k},
    \code{alpha} and \code{q}.
    }
    See \code{\link{SWIM}} for details.
}
\description{
Convert SWIMw to SWIM
}
\details{
Convert a SWIMw object into a SWIM object
}
\examples{
\dontrun{
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000),
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress_wass(type = "RM", x = x,
  alpha = 0.9, q_ratio = 1.05)
convert_SWIMw_to_SWIM(res1)
}

}
\author{
Kent Wu
}
