% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source_compete.R
\name{blm_bc_hs}
\alias{blm_bc_hs}
\title{Bayesian linear model with a Box-Cox transformation and a horseshoe prior}
\usage{
blm_bc_hs(
  y,
  X,
  X_test = X,
  lambda = NULL,
  sample_lambda = TRUE,
  only_theta = FALSE,
  nsave = 1000,
  nburn = 1000,
  nskip = 0,
  verbose = TRUE
)
}
\arguments{
\item{y}{\code{n x 1} vector of observed counts}

\item{X}{\code{n x p} matrix of predictors (no intercept)}

\item{X_test}{\code{n_test x p} matrix of predictors for test data;
default is the observed covariates \code{X}}

\item{lambda}{Box-Cox transformation; if NULL, estimate this parameter}

\item{sample_lambda}{logical; if TRUE, sample lambda, otherwise
use the fixed value of lambda above or the MLE (if lambda unspecified)}

\item{only_theta}{logical; if TRUE, only return posterior draws of the
regression coefficients (for speed)}

\item{nsave}{number of MCMC iterations to save}

\item{nburn}{number of MCMC iterations to discard}

\item{nskip}{number of MCMC iterations to skip between saving iterations,
i.e., save every (nskip + 1)th draw}

\item{verbose}{logical; if TRUE, print time remaining}
}
\value{
a list with the following elements:
\itemize{
\item \code{coefficients} the posterior mean of the regression coefficients
\item \code{fitted.values} the posterior predictive mean at the test points \code{X_test}
\item \code{post_theta}: \code{nsave x p} samples from the posterior distribution
of the regression coefficients
\item \code{post_ypred}: \code{nsave x n_test} samples
from the posterior predictive distribution at test points \code{X_test}
\item \code{post_g}: \code{nsave} posterior samples of the transformation
evaluated at the unique \code{y} values
\item \code{post_lambda}: \code{nsave} posterior samples of lambda
\item \code{post_sigma}: \code{nsave} posterior samples of sigma
\item \code{model}: the model fit (here, \code{blm_bc_hs})
}
as well as the arguments passed in.
}
\description{
MCMC sampling for Bayesian linear regression with 1) a
(known or unknown) Box-Cox transformation and 2) a horseshoe prior for
the (possibly high-dimensional) regression coefficients.
}
\details{
This function provides fully Bayesian inference for a
transformed linear model via MCMC sampling. The transformation is
parametric from the Box-Cox family, which has one parameter \code{lambda}.
That parameter may be fixed in advanced or learned from the data.

The horseshoe prior is especially useful for high-dimensional settings with
many (possibly correlated) covariates. This function
uses a fast Cholesky-forward/backward sampler when \code{p < n}
and the Bhattacharya et al. (<https://doi.org/10.1093/biomet/asw042>) sampler
when \code{p > n}. Thus, the sampler can scale linear in \code{n}
(for fixed/small \code{p}) or linear in \code{p} (for fixed/small \code{n}).
}
\note{
Box-Cox transformations may be useful in some cases, but
in general we recommend the nonparametric transformation in \code{\link{sblm_hs}}.

An intercept is automatically added to \code{X} and
\code{X_test}. The coefficients reported do *not* include
this intercept parameter, since it is not identified
under more general transformation models (e.g., \code{\link{sblm_hs}}).
}
\examples{
# Simulate data from a transformed (sparse) linear model:
dat = simulate_tlm(n = 100, p = 50, g_type = 'step', prop_sig = 0.1)
y = dat$y; X = dat$X # training data

hist(y, breaks = 25) # marginal distribution

# Fit the Bayesian linear model with a Box-Cox transformation & a horseshoe prior:
fit = blm_bc_hs(y = y, X = X, verbose = FALSE)
names(fit) # what is returned

}
