% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICComputePropDualSols}
\alias{seasonder_MUSICComputePropDualSols}
\title{Compute the Proportion of Dual Solutions in MUSIC Data}
\usage{
seasonder_MUSICComputePropDualSols(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing MUSIC data and other related attributes.}
}
\value{
A \code{SeaSondeRCS} object with the calculated proportion of "dual" solutions stored as
an attribute. This attribute can be accessed using a relevant getter function.
}
\description{
This function calculates the proportion of "dual" solutions in the MUSIC data
associated with a given \code{SeaSondeRCS} object. It updates the object with the computed
proportion as a new attribute.
}
\details{
The function performs the following steps:
\enumerate{
\item Extracts the MUSIC data from the provided \code{SeaSondeRCS} object.
\item Computes the proportion of entries in the \code{retained_solution} column of the MUSIC data
that are labeled as "dual".
\item Updates the \code{SeaSondeRCS} object by adding the computed proportion as an attribute
using \code{seasonder_setSeaSondeRCS_MUSIC_dual_solutions_proportion}.
}
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_MUSIC}} to retrieve the MUSIC data.
\code{\link{seasonder_setSeaSondeRCS_MUSIC_dual_solutions_proportion}} to set the computed proportion.
}
