% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_applyAPMAmplitudeAndPhaseCorrections}
\alias{seasonder_applyAPMAmplitudeAndPhaseCorrections}
\title{Apply Amplitude and Phase Corrections to a SeaSonde RAPM Object}
\usage{
seasonder_applyAPMAmplitudeAndPhaseCorrections(seasonder_apm_object)
}
\arguments{
\item{seasonder_apm_object}{A SeaSonde RAPM object containing raw data and correction factors.}
}
\value{
The SeaSonde RAPM object with amplitude and phase corrections applied to the data.
}
\description{
This function applies amplitude and phase corrections to each antenna channel
of a SeaSonde RAPM object based on the correction factors stored within the object.
}
\examples{
# Apply amplitude & phase corrections to a test SeaSondeRAPM object
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
obj <- seasonder_readSeaSondeRAPMFile(apm_file)
corrected_obj <- seasonder_applyAPMAmplitudeAndPhaseCorrections(obj)
}
