% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_computePowerMatrix}
\alias{seasonder_computePowerMatrix}
\title{Compute Power Matrix}
\usage{
seasonder_computePowerMatrix(eig, a)
}
\arguments{
\item{eig}{A list containing the eigenvalues and eigenvectors of a covariance matrix. The list should include:
\itemize{
\item \code{values}: A numeric vector of eigenvalues.
\item \code{vectors}: A matrix where each column is an eigenvector.
}}

\item{a}{A complex matrix representing the steering vector(s). Each column corresponds to a direction of arrival.}
}
\value{
A complex matrix representing the power matrix, calculated based on the provided eigenvalues, eigenvectors, and steering vectors. If the number of columns in \code{a} is zero, the function returns \code{NULL}.
}
\description{
This function calculates the power matrix based on the provided steering vector, eigenvalues, and eigenvectors. The computation differs depending on the number of columns in the steering vector matrix.
}
\details{
The function computes the power matrix using the following steps:
\itemize{
\item If \code{a} has two columns:
\enumerate{
\item Select the first two eigenvalues and their corresponding eigenvectors.
\item Compute the matrix \eqn{G = a^* \cdot \text{eigVector}}, where \eqn{a^*} is the conjugate transpose of \code{a}.
\item Calculate the inverse of \code{G} and its conjugate transpose.
\item Compute the power matrix \eqn{P = G_{\text{inv}}^* \cdot \text{diag(eigValues)} \cdot G_{\text{inv}}}.
}
\item If \code{a} has one column:
\enumerate{
\item Select the first eigenvalue and its corresponding eigenvector.
\item Follow similar steps as above with single-column operations.
}
}

If \code{a} has no columns, the function returns \code{NULL}.
}
\section{Mathematical Formula}{

For a steering vector matrix \eqn{a}, eigenvectors \eqn{\text{eigVector}}, and eigenvalues \eqn{\text{eigValues}}, the power matrix is calculated as:
\deqn{P = G_{\text{inv}}^* \cdot \text{diag(eigValues)} \cdot G_{\text{inv}}}
where:
\eqn{G = a^* \cdot \text{eigVector}}
and \eqn{G_{\text{inv}}} is the inverse of \eqn{G}.
}

\section{References}{

\itemize{
\item Paolo, T. de, Cook, T., & Terrill, E. (2007). Properties of HF RADAR Compact Antenna Arrays and Their Effect on the MUSIC Algorithm. \emph{OCEANS 2007}, 1–10. doi:10.1109/oceans.2007.4449265.
}
}

