% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_findFORNullsInSpectrum}
\alias{seasonder_findFORNullsInSpectrum}
\title{Identify Nulls in First Order Region (FOR) Spectrum}
\usage{
seasonder_findFORNullsInSpectrum(
  seasonder_cs_object,
  spectrum,
  doppler_bins,
  negative_Bragg_region = FALSE
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the spectral data.}

\item{spectrum}{A numeric vector representing the power spectrum to analyze.}

\item{doppler_bins}{A numeric vector containing the Doppler bins corresponding to the spectrum.}

\item{negative_Bragg_region}{A logical value indicating whether the function should analyze the negative Bragg region. Default is \code{FALSE}.}
}
\value{
A list with three elements:
\itemize{
\item \code{FOR}: A sequence of Doppler bins defining the first order region.
\item \code{MAXP}: The maximum power found in the spectrum.
\item \code{MAXP.bin}: The Doppler bin index of the maximum power.
}
}
\description{
This function locates the null points in the First Order Region (FOR) of a Doppler spectrum.
These nulls define the boundaries separating the first-order Bragg peak from the surrounding noise or second-order energy.
}
\details{
The function executes the following steps:
\enumerate{
\item \strong{Retrieve First Order Settings:} The function extracts the \code{fdown} parameter, which defines the drop-off level relative to the maximum power.
\item \strong{Prepare the Spectrum:}
\itemize{
\item Convert all values to negative absolute magnitudes to facilitate peak detection.
\item Reverse the spectrum and Doppler bins if analyzing the negative Bragg region.
}
\item \strong{Find the Main Spectral Peak:}
\itemize{
\item The function identifies the first major peak using \code{\link[pracma]{findpeaks}} with at least two consecutive increases and decreases.
\item The search is limited to the portion of the spectrum beyond this peak.
}
\item \strong{Determine the First Order Boundaries:}
\itemize{
\item The maximum power (\code{MAXP}) is found along with its bin index (\code{MAXP.bin}).
\item A threshold value \code{start_point_P} is computed as \code{MAXP / fdown} to establish the cutoff point for the null search.
}
\item \strong{Search for Nulls:} The spectrum is split into left and right sections:
\itemize{
\item The right-side spectrum is analyzed using \code{\link{seasonder_findFORNullsInFOR}} to find the right null.
\item The left-side spectrum undergoes the same process but reversed.
}
\item \strong{Output the Results:} The function returns a list containing:
\itemize{
\item The sequence of Doppler bins defining the FOR region.
\item The maximum power detected (\code{MAXP}).
\item The Doppler bin index where \code{MAXP} occurred (\code{MAXP.bin}).
}
}
}
\seealso{
\itemize{
\item \code{\link{seasonder_findFORNullsInFOR}} for detecting nulls within a selected region.
\item \code{\link[pracma]{findpeaks}} for peak identification.
\item \code{\link{seasonder_getFOR_parameters}} for retrieving FOR settings.
}
}
