% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_getFOR_currmax}
\alias{seasonder_getFOR_currmax}
\title{Retrieve FOR Maximum Radial Velocity Limit (currmax)}
\usage{
seasonder_getFOR_currmax(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing FOR parameters.}
}
\value{
The value of the 'currmax' parameter.
}
\description{
This function retrieves the maximum radial velocity ('currmax') parameter from the FOR parameters
in a SeaSondeRCS object.
}
\examples{
# Minimal example for seasonder_getFOR_currmax
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
currmax_value <- seasonder_getFOR_currmax(cs_obj)
print(currmax_value)
}
