% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getSeaSondeRCS_MUSIC_DopplerBinsFrequency}
\alias{seasonder_getSeaSondeRCS_MUSIC_DopplerBinsFrequency}
\title{Calculate Doppler Bins Frequencies for MUSIC Analysis}
\usage{
seasonder_getSeaSondeRCS_MUSIC_DopplerBinsFrequency(
  seasonder_cs_object,
  normalized = FALSE
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the data and parameters
for MUSIC analysis.}

\item{normalized}{Logical. If \code{TRUE}, the returned frequencies are normalized by the
positive Bragg frequency. Default is \code{FALSE}, returning frequencies in Hz.}
}
\value{
A numeric vector representing the frequency values for each Doppler bin.
If \code{normalized = TRUE}, these values are dimensionless, relative to the
positive Bragg frequency. Otherwise, they are in Hz.
}
\description{
This function computes the Doppler bin frequencies for a given \code{SeaSondeRCS} object,
incorporating adjustments from the MUSIC analysis. The computation accounts for
Doppler interpolation and the spectrum resolution.
}
\details{
The function performs the following steps:
\enumerate{
\item Retrieves the central Doppler bin corresponding to 0 frequency using
\code{\link{seasonder_getSeaSondeRCS_MUSIC_CenterDopplerBin}}.
\item Retrieves the total number of Doppler cells (adjusted for interpolation)
using \code{\link{seasonder_getSeaSondeRCS_MUSIC_nDopplerCells}}.
\item Retrieves the Doppler spectrum resolution using
\code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerSpectrumResolution}}.
\item Computes the Doppler bin frequencies using
\code{\link{seasonder_computeDopplerBinsFrequency}}.
}

The resulting Doppler bins frequencies are crucial for analyzing the spectral
properties of the MUSIC output.
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_MUSIC_CenterDopplerBin}} to retrieve the central bin.
\code{\link{seasonder_getSeaSondeRCS_MUSIC_nDopplerCells}} for the number of Doppler cells.
\code{\link{seasonder_getSeaSondeRCS_MUSIC_DopplerSpectrumResolution}} for the adjusted spectrum resolution.
\code{\link{seasonder_computeDopplerBinsFrequency}} for the frequency calculation.
}
