% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_validateFOR_parameters}
\alias{seasonder_validateFOR_parameters}
\title{Validate First Order Region (FOR) Parameters}
\usage{
seasonder_validateFOR_parameters(
  seasonder_cs_object,
  FOR_parameters,
  method = "SeaSonde"
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing metadata about the Doppler spectrum.}

\item{FOR_parameters}{A named list containing the parameters for first-order region detection.}

\item{method}{A character string specifying the validation method. Default is \code{"SeaSonde"}.
Currently, only "SeaSonde" is supported.}
}
\value{
A named list containing validated and completed FOR parameters.
}
\description{
This function validates and assigns default values to the parameters used in defining
the First Order Region (FOR) in a SeaSondeR cross-spectral object. It ensures that all
necessary parameters are present and assigns appropriate defaults where values are missing.
}
\details{
The function validates FOR parameters and assigns default values where necessary.
If the selected method is "SeaSonde", the function ensures that each parameter is
defined and, if missing, assigns it a default value based on \code{\link{seasonder_defaultFOR_parameters}}.

The parameters validated include:
\itemize{
\item \strong{nsm} (Doppler Smoothing): Number of points used for spectral smoothing.
\item \strong{fdown} (Peak Power Dropoff): Defines how far below peak power the algorithm descends before searching for the null.
\item \strong{flim} (Null Below Peak Power): Specifies a power threshold for identifying the first-order region.
\item \strong{noisefact} (Signal to Noise): Threshold above the noise floor that a spectral bin must exceed to be considered first-order.
\item \strong{currmax} (Maximum Velocity): Maximum radial velocity allowed in the first-order region.
\item \strong{reject_distant_bragg}: Logical flag indicating whether to reject Bragg regions that are too distant from the central Bragg frequency.
\item \strong{reject_noise_ionospheric}: Logical flag indicating whether to reject Bragg regions affected by ionospheric noise.
\item \strong{reject_noise_ionospheric_threshold}: Threshold (in dB) for rejecting first-order regions based on noise contamination.
\item \strong{reference_noise_normalized_limits}: Estimated reference noise range in normalized Doppler frequency,
computed using \code{\link{seasonder_estimateReferenceNoiseNormalizedLimits}}.
}
}
\seealso{
\itemize{
\item \code{\link{seasonder_defaultFOR_parameters}} for default FOR settings.
\item \code{\link{seasonder_estimateReferenceNoiseNormalizedLimits}} for computing reference noise limits.
\item \code{\link{seasonder_validateFORMethod}} for validating the processing method.
}
}
