% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_check_specs}
\alias{seasonder_check_specs}
\title{Validate Field Specifications}
\usage{
seasonder_check_specs(specs, fields)
}
\arguments{
\item{specs}{A list containing field specifications.}

\item{fields}{A character vector of field names to be checked in the \code{specs}.}
}
\value{
Invisibly returns NULL.
}
\description{
This function checks if the provided specifications (\code{specs}) contain entries for all the required fields listed in \code{fields}.
}
\details{
The function iterates over each field in the \code{fields} vector and checks if there is an associated entry in the \code{specs} list.
If any field is missing, an error is thrown using \code{seasonder_logAndAbort} indicating the missing field specification.
}
\section{Condition Management}{

This function utilizes the \code{rlang} package to manage conditions, and provide detailed and structured condition messages:

\strong{Condition Classes}:
\itemize{
\item \code{spsr_field_specification_missing_error}: This error is thrown when a required field specification is missing from the \code{specs} list.
}

\strong{Condition Cases}:
\itemize{
\item Required field specification is missing.
}
}

